package examples.stateless.client;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import examples.stateless.interfaces.PricerInjection;
import examples.stateless.interfaces.PricerLookup;

public class PricerClient {
	public static void main(String[] args) {
		try {
			InitialContext ic = new InitialContext();

			// Prefixing the name with the pound sign (#) is a convention of Glassfish
			// when using multiple interfaces to make up the business interface. The 
			// specification is unclear on how clients should lookup beans that implement
			// more than one interface.
			
			PricerLookup pricerLookup = (PricerLookup)ic.lookup("#"+PricerLookup.class.getName());
			PricerInjection pricerInjection = (PricerInjection)ic.lookup("#"+PricerInjection.class.getName());
			//PricerLookup pricerLookup = (PricerLookup)ic.lookup(PricerLookup.class.getName());
			//PricerInjection pricerInjection = (PricerInjection)ic.lookup(PricerInjection.class.getName());
			//Pricer pricerLookup = (Pricer)ic.lookup(Pricer.class.getName());
			//Pricer pricerInjection = pricerLookup;

			System.out.println("Tax (using lookup) on: 8.5 for State: ny is: "+
					pricerLookup.getTaxLookup(8.5,"ny"));
			
			System.out.println("Tax (using injection) on: 8.5 for State: ny is: "+
					pricerInjection.getTaxInjection(8.5,"ny"));
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
